import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Scanner;
import java.io.File;

public class Problem_1_Martian_Time {
    
    public static final double RATIO = 86400 / 88642.663; // earth day : mars day (in seconds)
    public static final DecimalFormat DF = new DecimalFormat("00"); // just to format the output
    
    public static void main(String[] args) {

        try {
            Scanner scanner = new Scanner(new File("F:\\data\\DATA11.txt"));
            ArrayList<String> list = new ArrayList<String>();
            
            // read in the file to the ArrayList
            while (scanner.hasNextLine()) {
                list.add(scanner.nextLine());
            }

            for (String line : list) {

                String[] s = line.split("\\s+"); // split line by white space

                int day = Integer.parseInt(s[0]);
                int hour = Integer.parseInt(s[1]);
                int minute = Integer.parseInt(s[2]);

                /* Convert Earth time from days, hours and minutes into seconds
                   then figure out that Mars time in seconds
                   then convert the Mars time from seconds to days, hours and minutes. */

                // choose one or the other (both algorithms give the same output)
                differenceAlgorithm(day, hour, minute);
                moduloAlgorithm(day, hour, minute);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        
    }

    /* Independent of moduloAlgorithm, this method is one solution */
    public static void differenceAlgorithm(int d, int h, int m) {
        // 60 seconds in a minute, 60 minutes in an hour, 24 hours in a day
        double earthSeconds = d * 60 * 60 * 24 + h * 60 * 60 + m * 60;
        double marsSeconds = earthSeconds * RATIO;
        
        marsSeconds += 2160; // add 36 minutes (it works for some reason)

        int days = (int)marsSeconds / 86400; // whole number of days
        int daysInSeconds = days * 86400; // whole days represented in seconds

        // seconds left to be distributed to the hours and minutes (days are done)
        double secondsLeft = marsSeconds - daysInSeconds;

        int hours = (int)(secondsLeft / 3600); // whole number of hours
        int hoursInSeconds = hours * 3600; // whole hours represented in seconds

        // seconds left to be distributed to the minutes (days and hours are done)
        secondsLeft = marsSeconds - daysInSeconds - hoursInSeconds;

        double minutes = secondsLeft / 60;
        
        // minutes += 36; // add 36 minutes (it works for some reason)

        // needs to be here in case the minutes get rounded up to an hour
        if (minutes >= 59.5) {
            hours += 1;
            minutes -= 60;
            
            if (hours >= 24) {
                days += 1;
                hours -= 24;
            }
        }

        System.out.print("Day " + days + ", ");
        System.out.print(DF.format(hours) + ":");
        System.out.println(DF.format(Math.abs(minutes))); // absolute value so negative number rounded doesn't show negative sign
    }
    
    /* Independent of differenceAlgorithm, this method is one solution */
    public static void moduloAlgorithm(int d, int h, int m) {
        // 60 seconds in a minute, 60 minutes in an hour, 24 hours in a day
        double earthSeconds = d * 60 * 60 * 24 + h * 60 * 60 + m * 60;
        double marsSeconds = earthSeconds * RATIO;
        
        // marsSeconds += 2160; // add 36 minutes (it works for some reason)

        int days = (int)marsSeconds / 86400; // whole number of days
        
        // remainder from factoring out the days
        double secondsLeft = marsSeconds % 86400;

        // whole number of hours
        int hours = (int)(secondsLeft / 3600);

        // remainder from factoring out the hours
        secondsLeft %= 3600;

        double minutes = secondsLeft / 60;
        
        minutes += 36; // add 36 minutes (it works for some reason)

        // needs to be here in case the minutes get rounded up to an hour
        if (minutes >= 59.5) {
            hours += 1;
            minutes -= 60;
            
            if (hours >= 24) {
                days += 1;
                hours -= 24;
            }
        }

        System.out.print("Day " + days + ", ");
        System.out.print(DF.format(hours) + ":");
        System.out.println(DF.format(Math.abs(minutes))); // absolute value so negative number rounded doesn't show negative sign
    }
}